<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Registration Entity
 *
 * @property int $id
 * @property int $data_type
 * @property string|null $salutation
 * @property string|null $name
 * @property string|null $last_name
 * @property string|null $mobile_no
 * @property string|null $whatsapp_no
 * @property string|null $father_name
 * @property string|null $mother_name
 * @property string|null $gender
 * @property string|null $age
 * @property string|null $days
 * @property \Cake\I18n\FrozenDate|null $date_of_birth
 * @property \Cake\I18n\FrozenDate|null $anniversary_date
 * @property string|null $emailid
 * @property string|null $id_proof_type
 * @property string|null $id_proof_number
 * @property string|null $upload_id_proof
 * @property string|null $marital_status
 * @property string|null $state
 * @property string|null $district
 * @property string|null $city
 * @property string|null $address
 * @property string|null $pincode
 * @property string|null $religion
 * @property string|null $occupation
 * @property string|null $education
 * @property string|null $neet_roll_number
 * @property string|null $neet_score_markes
 * @property string|null $remark
 * @property int $date_add
 * @property int $user_id
 *
 * @property \App\Model\Entity\User $user
 */
class Registration extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        'data_type' => true,
        'salutation' => true,
        'name' => true,
        'last_name' => true,
        'mobile_no' => true,
        'whatsapp_no' => true,
        'father_name' => true,
        'mother_name' => true,
        'gender' => true,
        'age' => true,
        'days' => true,
        'date_of_birth' => true,
        'anniversary_date' => true,
        'emailid' => true,
        'id_proof_type' => true,
        'id_proof_number' => true,
        'upload_id_proof' => true,
        'marital_status' => true,
        'state' => true,
        'district' => true,
        'city' => true,
        'address' => true,
        'pincode' => true,
        'religion' => true,
        'occupation' => true,
        'education' => true,
        'neet_roll_number' => true,
        'neet_score_markes' => true,
        'remark' => true,
        'date_add' => true,
        'user_id' => true,
        'user' => true,
        'images' => true,
        'recall_date' => true,
        'treatment_department' => true,
		'uuid'=>true,
        'diagnosis' => true,
    ];
}
