<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * AgeGroups Model
 *
 * @property \App\Model\Table\VaccineNameTable&\Cake\ORM\Association\HasMany $VaccineName
 *
 * @method \App\Model\Entity\AgeGroup get($primaryKey, $options = [])
 * @method \App\Model\Entity\AgeGroup newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\AgeGroup[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\AgeGroup|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\AgeGroup saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\AgeGroup patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\AgeGroup[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\AgeGroup findOrCreate($search, callable $callback = null, $options = [])
 */
class AgeGroupsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('age_groups');
        $this->setDisplayField('name');
        $this->setPrimaryKey('id');

        $this->hasMany('VaccineName', [
            'foreignKey' => 'age_group_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmptyString('id', null, 'create');

        $validator
            ->scalar('name')
            ->maxLength('name', 255)
            ->requirePresence('name', 'create')
            ->notEmptyString('name');

        $validator
            ->integer('due_days')
            ->allowEmptyString('due_days');

        return $validator;
    }
}
