<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Counter Model
 *
 * @method \App\Model\Entity\Counter get($primaryKey, $options = [])
 * @method \App\Model\Entity\Counter newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Counter[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Counter|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Counter saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Counter patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Counter[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Counter findOrCreate($search, callable $callback = null, $options = [])
 */
class CounterTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('counter');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmptyString('id', null, 'create');

        $validator
            ->scalar('counter')
            ->maxLength('counter', 20)
            ->requirePresence('counter', 'create')
            ->notEmptyString('counter');

        $validator
            ->scalar('suffex')
            ->maxLength('suffex', 20)
            ->requirePresence('suffex', 'create')
            ->notEmptyString('suffex');

        $validator
            ->scalar('count')
            ->maxLength('count', 20)
            ->requirePresence('count', 'create')
            ->notEmptyString('count');

        return $validator;
    }
}
