<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Registration Model
 *
 * @property \App\Model\Table\UsersTable&\Cake\ORM\Association\BelongsTo $Users
 *
 * @method \App\Model\Entity\Registration get($primaryKey, $options = [])
 * @method \App\Model\Entity\Registration newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Registration[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Registration|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Registration saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Registration patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Registration[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Registration findOrCreate($search, callable $callback = null, $options = [])
 */
class RegistrationTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('registration');
        $this->setDisplayField('name');
        $this->setPrimaryKey('id');

        $this->belongsTo('Users', [
            'foreignKey' => 'user_id',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('Category', [
            'foreignKey' => 'data_type ',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('Treatment', [
            'className' => 'treatment_department',
            'foreignKey' => 'treatment_department ',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmptyString('id', null, 'create');

        $validator
            ->integer('data_type')
            ->requirePresence('data_type', 'create')
            ->notEmptyString('data_type');

        $validator
            ->scalar('salutation')
            ->maxLength('salutation', 10)
            ->allowEmptyString('salutation');

        $validator
            ->scalar('name')
            ->maxLength('name', 50)
            ->allowEmptyString('name');

        $validator
            ->scalar('last_name')
            ->maxLength('last_name', 20)
            ->allowEmptyString('last_name');

        $validator
            ->scalar('mobile_no')
            ->maxLength('mobile_no', 20)
            ->allowEmptyString('mobile_no');

        $validator
            ->scalar('whatsapp_no')
            ->maxLength('whatsapp_no', 20)
            ->allowEmptyString('whatsapp_no');

        $validator
            ->scalar('father_name')
            ->maxLength('father_name', 50)
            ->allowEmptyString('father_name');

        $validator
            ->scalar('mother_name')
            ->maxLength('mother_name', 50)
            ->allowEmptyString('mother_name');

        $validator
            ->scalar('gender')
            ->maxLength('gender', 10)
            ->allowEmptyString('gender');

        $validator
            ->scalar('age')
            ->maxLength('age', 10)
            ->allowEmptyString('age');

        $validator
            ->scalar('days')
            ->maxLength('days', 10)
            ->allowEmptyString('days');
            
        $validator
            ->scalar('date_of_birth')
            ->maxLength('date_of_birth', 20)
            ->allowEmptyString('date_of_birth');

        $validator
            ->scalar('anniversary_date')
            ->maxLength('anniversary_date', 20)
            ->allowEmptyString('anniversary_date');

        $validator
            ->scalar('emailid')
            ->maxLength('emailid', 50)
            ->allowEmptyString('emailid');

        $validator
            ->scalar('id_proof_type')
            ->maxLength('id_proof_type', 20)
            ->allowEmptyString('id_proof_type');

        $validator
            ->scalar('id_proof_number')
            ->maxLength('id_proof_number', 50)
            ->allowEmptyString('id_proof_number');

        $validator
            ->scalar('upload_id_proof')
            ->maxLength('upload_id_proof', 255)
            ->allowEmptyString('upload_id_proof');

        $validator
            ->scalar('marital_status')
            ->maxLength('marital_status', 10)
            ->allowEmptyString('marital_status');

        $validator
            ->scalar('state')
            ->maxLength('state', 10)
            ->allowEmptyString('state');

        $validator
            ->scalar('district')
            ->maxLength('district', 10)
            ->allowEmptyString('district');

        $validator
            ->scalar('city')
            ->maxLength('city', 100)
            ->allowEmptyString('city');

        $validator
            ->scalar('address')
            ->maxLength('address', 200)
            ->allowEmptyString('address');

        $validator
            ->scalar('pincode')
            ->maxLength('pincode', 10)
            ->allowEmptyString('pincode');

        $validator
            ->scalar('religion')
            ->maxLength('religion', 20)
            ->allowEmptyString('religion');

        $validator
            ->scalar('occupation')
            ->maxLength('occupation', 50)
            ->allowEmptyString('occupation');

        $validator
            ->scalar('education')
            ->maxLength('education', 50)
            ->allowEmptyString('education');

        $validator
            ->scalar('neet_roll_number')
            ->maxLength('neet_roll_number', 50)
            ->allowEmptyString('neet_roll_number');

        $validator
            ->scalar('neet_score_markes')
            ->maxLength('neet_score_markes', 50)
            ->allowEmptyString('neet_score_markes');

        $validator
            ->scalar('remark')
            ->allowEmptyString('remark');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['user_id'], 'Users'));
        $rules->add($rules->existsIn(['data_type'], 'Category'));

        return $rules;
    }
}
