<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * SukanyaVaccineChart Model
 *
 * @property \App\Model\Table\RegistrationsTable&\Cake\ORM\Association\BelongsTo $Registrations
 * @property \App\Model\Table\AgeGroupsTable&\Cake\ORM\Association\BelongsTo $AgeGroups
 * @property \App\Model\Table\VaccinesTable&\Cake\ORM\Association\BelongsTo $Vaccines
 * @property \App\Model\Table\UsersTable&\Cake\ORM\Association\BelongsTo $Users
 *
 * @method \App\Model\Entity\SukanyaVaccineChart get($primaryKey, $options = [])
 * @method \App\Model\Entity\SukanyaVaccineChart newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\SukanyaVaccineChart[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\SukanyaVaccineChart|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\SukanyaVaccineChart saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\SukanyaVaccineChart patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\SukanyaVaccineChart[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\SukanyaVaccineChart findOrCreate($search, callable $callback = null, $options = [])
 */
class SukanyaVaccineChartTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('sukanya_vaccine_chart');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');

        $this->belongsTo('Registrations', [
            'className'=>'registration',
            'foreignKey' => 'registration_id',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('AgeGroups', [
            'foreignKey' => 'age_group_id',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('Vaccines', [
            'className' => 'vaccine_name',
            'foreignKey' => 'vaccine_id',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('Users', [
            'foreignKey' => 'user_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmptyString('id', null, 'create');

        $validator
            ->date('due_date')
            ->requirePresence('due_date', 'create')
            ->notEmptyDate('due_date');

        $validator
            ->date('given_date')
            ->allowEmptyDate('given_date');

        $validator
            ->scalar('batch_no')
            ->maxLength('batch_no', 20)
            ->allowEmptyString('batch_no');

        $validator
            ->scalar('weight')
            ->maxLength('weight', 10)
            ->allowEmptyString('weight');

        $validator
            ->scalar('head_circumference')
            ->maxLength('head_circumference', 20)
            ->allowEmptyString('head_circumference');

        $validator
            ->scalar('height')
            ->maxLength('height', 10)
            ->allowEmptyString('height');

        $validator
            ->scalar('comment')
            ->allowEmptyString('comment');

        $validator
            ->dateTime('add_date')
            ->notEmptyDateTime('add_date');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['registration_id'], 'Registrations'));
        $rules->add($rules->existsIn(['age_group_id'], 'AgeGroups'));
        $rules->add($rules->existsIn(['vaccine_id'], 'Vaccines'));
        $rules->add($rules->existsIn(['user_id'], 'Users'));

        return $rules;
    }
}
