<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * VaccineName Model
 *
 * @property \App\Model\Table\AgeGroupsTable&\Cake\ORM\Association\BelongsTo $AgeGroups
 *
 * @method \App\Model\Entity\VaccineName get($primaryKey, $options = [])
 * @method \App\Model\Entity\VaccineName newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\VaccineName[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\VaccineName|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\VaccineName saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\VaccineName patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\VaccineName[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\VaccineName findOrCreate($search, callable $callback = null, $options = [])
 */
class VaccineNameTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('vaccine_name');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');

        $this->belongsTo('AgeGroups', [
            'foreignKey' => 'age_group_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmptyString('id', null, 'create');

        $validator
            ->scalar('vaccine_name')
            ->maxLength('vaccine_name', 255)
            ->requirePresence('vaccine_name', 'create')
            ->notEmptyString('vaccine_name');

        $validator
            ->scalar('comment')
            ->allowEmptyString('comment');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['age_group_id'], 'AgeGroups'));

        return $rules;
    }
}
