<?php
/**
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link          https://cakephp.org CakePHP(tm) Project
 * @since         0.10.0
 * @license       https://opensource.org/licenses/mit-license.php MIT License
 * @var \App\View\AppView $this
 */

$cakeDescription = 'Perfect Database Management';
?>
<!DOCTYPE html>
<html>
<head>
    <?= $this->Html->charset() ?>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>
        <?= $cakeDescription ?>:
        <?= $this->fetch('title') ?>
    </title>
    <?= $this->Html->meta('icon') ?>

    <?php echo $this->Html->css('styles.css');?>
    <?php echo $this->Html->css('custom.css');?>

    <?= $this->fetch('meta') ?>
    <?= $this->fetch('css') ?>
    <?= $this->fetch('script') ?>
</head>
<body>
    <div class="page-wrapper" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full"
    data-sidebar-position="fixed" data-header-position="fixed">
        <?= $this->element('siderbar'); ?>
        <div class="body-wrapper">
            <?= $this->element('header'); ?>
            <div class="container-fluid">
                <?= $this->Flash->render() ?>
                <?= $this->fetch('content') ?>
            </div>
        </div>
    </div>

    <?php echo $this->Html->script('libs/jquery/dist/jquery.min.js');?>
    <?php echo $this->Html->script('libs/bootstrap/dist/js/bootstrap.bundle.min.js');?>
    <?php echo $this->Html->script('sidebarmenu.js');?>
    <?php echo $this->Html->script('app.min.js');?>
    <?php echo $this->Html->script('libs/apexcharts/dist/apexcharts.min.js');?>
    <?php echo $this->Html->script('libs/simplebar/dist/simplebar.js');?>
</body>
</html>
