<div class="users index large-9 medium-8 columns content">
    <div align="center"><h3><?= __('Users List') ?></h3></div>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th scope="col"><?= $this->Paginator->sort('id') ?></th>
                <th scope="col"><?= $this->Paginator->sort('name') ?></th>
                <th scope="col"><?= $this->Paginator->sort('username') ?></th>
                <th scope="col"><?= $this->Paginator->sort('roal') ?></th>
                <th scope="col"><?= $this->Paginator->sort('status') ?></th>
                <th scope="col" class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($users as $user): ?>
            <tr>
                <td><?= $this->Number->format($user->id) ?></td>
                <td><?= h($user->name) ?></td>
                <td><?= h($user->username) ?></td>
                <td><?php if($user->user_roal==1){ echo "Admin";}else{ echo "Non Admin";}?></td>
                <td><?php if($user->status==0){?><span class="badge bg-success rounded-3 fw-semibold">Active</span><?php }else{?><span class="badge bg-danger rounded-3 fw-semibold">Inactive</span><?php } ?></td>
                <td class="actions">
                    <!-- <?= $this->Html->link(__('View'), ['action' => 'view', $user->id]) ?> -->
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $user->id.$_COOKIE['csrfToken']],['class'=>'btn btn-success']) ?>
                    <?php if($user->status==0){?>
                        <?= $this->Form->postLink(__('Inactive'), ['action' => 'delete', $user->id,1], ['confirm' => __('Are you sure you want to Inactive User {0}?', $user->name),'class'=>'btn btn-danger']) ?>
                    <?php }else{?>
                        <?= $this->Form->postLink(__('Active'), ['action' => 'delete', $user->id,0], ['confirm' => __('Are you sure you want to Active User {0}?', $user->name),'class'=>'btn btn-danger']) ?>
                    <?php }?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(['format' => __('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')]) ?></p>
    </div>
</div>
