<?= $this->Form->create($registration,['type'=>'file']) ?>
  <div class="row">
    <div class="col-lg-12 d-flex align-items-strech">
      <div class="card w-100">
        <div class="card-body">
          <div class="d-sm-flex d-block align-items-center justify-content-between mb-9">
            <div class="mb-3 mb-sm-0">
              <h5 class="card-title fw-semibold">Registration</h5>
            </div>
          </div>
          <div class="row">
            <div class="col-xs-2 col-sm-2 col-md-2 col-lg-2 allow_webcam" style="display: none;">
              <div id="my_camera"></div>
              <input type="hidden" name="image" class="image-tag" id="pat_image">
            </div>
            <div class="col-md-2 allow_webcam" style="display: none;"><input type=button class="btn btn-primary" value="<?= __('Take Pt. Photo');?>" onClick="take_snapshot()"></div>
            <div class="col-md-2" id="allow_webcam"><?=$this->Form->button('Allow Webcam', ['type'=>'button','class'=>'btn btn-primary','onclick'=>'allow_webcam()'])?></div>
            <div class="col-xs-3 col-sm-3 col-md-3 col-lg-3">
              <div id="results"></div>
            </div>
            <div class="col-md-3">
              <label>Upload Image</label>
              <?=$this->Form->control('menula_image', ['label'=>false,'type'=>'file','class'=>'form-control'])?>
            </div>
          </div>
          <div class="row mt-2">
            <div class="col-md-3">
              <label>UUID</label>
              <?=$this->Form->control('uuid', ['value'=>$uuid_count,'class'=>'form-control','label'=>false,'readonly'=>true])?>
            </div>
            <div class="col-md-3">
              <label>Data Type</label>
              <?=$this->Form->select('data_type', $category_list,['class'=>'form-control','onchange'=>"check_data_type(this.value)"])?>
            </div>
            <div class="col-md-3">
              <label>Name</label>
              <div style="display: inline-flex;">
                <?php echo $this->Form->control('salutation', ['options'=>['Mr.'=>'Mr.','Mrs.'=>'Mrs.','Miss.'=>'Miss.','Master'=>'Master','Baby'=>'Baby','Ms.'=>"Ms.",'Dr.'=>'Dr.','Fr.'=>'Fr.','Er.'=>'Er.'],'label'=>false,'class'=>'form-control','onchange'=>'salutation_change(this.value)']);?>
                <?=$this->Form->control('name', ['label'=>false,'class'=>'form-control'])?>
              </div>
            </div>
            <div class="col-md-3">
              <label>Last Name</label>
              <?=$this->Form->control('last_name', ['label'=>false,'class'=>'form-control'])?>
            </div>
          </div>
          <div class="row mt-2">
            <div class="col-md-3">
              <label>Mobile No.</label>
              <?=$this->Form->control('mobile_no' ,['label'=>false,'class'=>'form-control'])?>
            </div>
            <div class="col-md-3">
              <label>Whatsapp No.</label>
              <?=$this->Form->control('whatsapp_no' ,['label'=>false,'class'=>'form-control'])?>
            </div>
            <div class="col-md-3">
              <label>Father Name</label>
              <?=$this->Form->control('father_name', ['label'=>false,'class'=>'form-control'])?>
            </div>
            <div class="col-md-3">
              <label>Mother Name</label>
              <?=$this->Form->control('mother_name', ['label'=>false,'class'=>'form-control'])?>
            </div>
          </div>
          <div class="row mt-2">
            <div class="col-md-3">
              <label>Gender</label>
              <?=$this->Form->control('gender', ['label'=>false,'class'=>'form-control','options'=>['Male'=>'Male','Female'=>'Female','Other'=>'Other']])?>
            </div>
            <div class="col-md-3">
              <label>Age</label>
              <div style="display: inline-flex;">
                <?=$this->Form->control('age', ['label'=>false,'class'=>'form-control'])?>
                <?=$this->Form->control('days', ['label'=>false,'class'=>'form-control','options'=>['1'=>'Years','2'=>'Month','3'=>'Days']])?>
              </div>
            </div>
            <div class="col-md-3">
              <label>Date Of Birth</label>
              <?=$this->Form->control('date_of_birth', ['label'=>false,'class'=>'form-control datepicker_date'])?>
            </div>
            <div class="col-md-3">
              <label>Anniversary Date</label>
              <?=$this->Form->control('anniversary_date', ['label'=>false,'class'=>'form-control datepicker_date'])?>
            </div>
          </div>
          <div class="row mt-2">
            <div class="col-md-3">
              <label>Email ID</label>
              <?=$this->Form->control('emailid',['label'=>false,'class'=>'form-control'])?>
            </div>
            <div class="col-md-3">
              <label>ID Proof Type</label>
              <?=$this->Form->control('id_proof_type', ['label'=>false,'class'=>'form-control','options'=>[''=>'Select','Adhaar Card'=>'Adhaar Card','Voter ID'=>'Voter ID','VISA'=>'VISA','Passport'=>'Passport','Driving Licence'=>'Driving Licence','Student ID'=>'Student ID','PAN Card'=>'PAN Card']])?>
            </div>
            <div class="col-md-3">
              <label>ID Proof Number</label>
              <?=$this->Form->control('id_proof_number', ['label'=>false,'class'=>'form-control'])?>
            </div>
            <div class="col-md-3">
              <label>Upload ID Proof</label>
              <?=$this->Form->control('upload_id_proof',['label'=>false,'type'=>'file','class'=>'form-control'])?>
            </div>
          </div>
          <div class="row mt-2">
            <div class="col-md-3">
              <label>Marital Status</label>
              <?=$this->Form->control('marital_status', ['label'=>false,'class'=>'form-control','options'=>[''=>'Select','Single'=>'Single','Married'=>'Married','Widowed'=>'Widowed','Separated'=>'Separated','Not Specified'=>'Not Specified']])?>
            </div>
            <div class="col-md-3">
              <?php echo $this->Form->control('state', ['options'=>$state_list,'onchange'=>"get_district_list(this.value,'')",'empty'=>'Select State','class'=>'form-control']);?>
            </div>
            <div class="col-md-3">
                <?php echo $this->Form->control('district', ['options'=>[''=>'Select District'],'id'=>'district_id','class'=>'form-control']);?>
            </div>
            <div class="col-md-3">
                <label>City/Town</label>
                <?php echo $this->Form->control('city', ['label'=>false,'class'=>'form-control'])?>
            </div>
          </div>
          <div class="row mt-2">
            <div class="col-md-3">
              <label>Address</label>
                <?php echo $this->Form->control('address', ['label'=>false,'class'=>'form-control']);?>
            </div>
            <div class="col-md-3">
              <label>Pin Code</label>
                <?php echo $this->Form->control('pincode', ['label'=>false,'class'=>'form-control']);?>
            </div>
            <div class="col-md-3">
              <?=$this->Form->control('religion', ['options'=>['Hinduism'=>'Hinduism','Islam'=>'Islam','Christianity'=>'Christianity','Sikhism'=>'Sikhism','Buddhism'=>'Buddhism','Jainism'=>'Jainism','Unaffiliated'=>'Unaffiliated'],'class'=>'form-control'])?>
            </div>
            <div class="col-md-3">
              <label>Occupation</label>
              <?php echo $this->Form->control('occupation', ['label'=>false,'class'=>'form-control'])?>
            </div>
          </div>
          <div class="row mt-2">
            <div class="col-md-3">
              <label>Education</label>
              <?=$this->Form->control('education', ['label'=>false,'class'=>'form-control'])?>
            </div>
            <div class="col-md-3 admission" style="display: none;">
              <label>NEET Roll Number</label>
              <?=$this->Form->control('neet_roll_number', ['label'=>false,'class'=>'form-control'])?>
            </div>
            <div class="col-md-3 admission" style="display: none;">
              <label>NEET Score Marks</label>
              <?=$this->Form->control('neet_score_markes', ['label'=>false,'class'=>'form-control'])?>
            </div>
            <div class="col-md-3">
              <label>Treatment Department</label>
              <?=$this->Form->control('treatment_department', ['label'=>false,'options'=>$treatment_department,'empty'=>'Select','class'=>'form-control'])?>
            </div>
            <div class="col-md-6">
              <label>Diagnosis</label>
              <?=$this->Form->control('diagnosis_name', ['label'=>false,'options'=>$diagnosis_list,'class'=>'form-control js-example-basic-multiple','multiple'=>true])?>
            </div>
            <div class="col-md-3">
              <label>Recall Date</label>
              <?=$this->Form->control('recall_date', ['label'=>false,'class'=>'form-control datepicker_date','type'=>'text'])?>
            </div>
          </div>
          <div class="row mt-2">
            <div class="col-md-12">
              <label>Remarks</label>
              <?=$this->Form->textarea('remark', ['label'=>false,'class'=>'form-control'])?>
            </div>
          </div>
          <div class="row mt-2">
            <div class="col-md-12" align="center">
              <?=$this->Form->button('save data', ['class'=>'btn btn-success'])?>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
<?= $this->Form->end() ?>

<?= $this->Html->script('libs/jquery/dist/jquery.min.js') ?>
<?php echo $this->Html->css('bootstrap-datepicker.min.css'); ?>
<?php echo $this->Html->script('bootstrap-datepicker.min.js'); ?>
<?= $this->Html->script('webcam.min.js') ?>
<?= $this->Html->css('select2.min.css') ?>
<?= $this->Html->script('select2.min.js') ?>
<script type="text/javascript">
  function salutation_change(sal_id){
    var male = 'Male';
    var female = 'Female';
    if (sal_id=='Mr.') {
      $("#gender").val(male);
    } else if (sal_id=='Mrs.'){
      $("#gender").val(female);
    } else if (sal_id=='Miss.'){
      $("#gender").val(female);
    } else if (sal_id=='Master'){
      $("#gender").val(male);
    } else if (sal_id=='Baby'){
      $("#gender").val('');
    } else if (sal_id=='Ms.'){
      $("#gender").val(female);
    } else {
      $("#gender").val('');
    }
  }
  function get_district_list(id,district)
  {
    var csrfToken = <?= json_encode($this->request->getParam('_csrfToken')) ?>;
    $.ajax({
      type:'GET',
      url:'<?php echo $this->Url->build(['controller'=>'users','action'=>'get-district-list']); ?>/'+id,
      headers: { 'X-CSRF-Token': csrfToken },
      success:function(data){
        $("#district_id").html(data);
        $("#district_id").val(district);
      }
    });
  }

  function check_data_type(id)
  {
    $(".admission").hide();
    if (id==3 || id==4) {
      $(".admission").show();
    }
  }
</script>
<script type="text/javascript">
  $(function () {
    $('.datepicker_date').datepicker({
      format: "dd-mm-yyyy",
      autoclose: true
    });
    $(".js-example-basic-multiple").select2();
  });
</script>
<script type="text/javascript">

  function allow_webcam()
  {
    $(".allow_webcam").show();
    $("#allow_webcam").hide();
    //Webcam Image
    Webcam.set({
      width: 180,
      height: 140,
      image_format: 'jpeg',
      jpeg_quality: 90
    });
    Webcam.attach( '#my_camera' );
  }
  function take_snapshot() {
    Webcam.snap( function(data_uri) {
    $(".image-tag").val(data_uri);
      document.getElementById('results').innerHTML = '<img src="'+data_uri+'"/>';
    });
  }
</script>