<script>
  $(document).ready(function() {
    $('#prescription_model').modal('show');
  });

  function modal_hide()
  {
    $('#prescription_model').modal('hide');
  }
</script>
<style type="text/css">
  .modal-header{
    background: #47c9a2;
    border-bottom: none;   
    position: relative;
    color: #fff;
    font-size: 1.4rem;
    font-weight: bold;
  }
  .col-md-1,.col-md-2,.col-md-12,.col-md-3,.col-md-10,.col-md-8,.col-md-6 {
    padding-left:1px;
    padding-right: 0px;
  }
  .modal-dialog{
      overflow-y: initial !important
  }
  .modal-body{
      max-height: calc(100vh - 80px);
      overflow-y: auto;
  }
  .panel-body table tr td {
    padding: 1px;
  }
  .row {margin: 0px;}
</style>
<div class="modal fade" id="prescription_model" role="dialog">
  <div class="modal-dialog" style="max-width: 100%;">
    <div class="modal-content">
      <div class="modal-header">
        <table width="100%">
          <tr>
            <td><span class="modal-title">Registration Data</span></td>
            <td><span class="modal-title">UUID : <?=$data->uuid?></span></td>
            <td><span class="modal-title">NAME : <?=$data->name?> <?=$data->last_name?></span></td>
            <td><span class="modal-title">AGE/SEX : <?=$data->age?>/<?=$data->gender?></span></td>
            <td>
              <button type="button" class="close btn btn-danger" onclick="modal_hide()">
                <span aria-hidden="true">&times;</span>
              </button>
            </td>
          </tr>
        </table>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-md-2"><label>Image</label></div>
          <div class="col-md-4">
            <?php if(!empty($data->images) && isset($data->images)){?>
              <?=$this->Html->image('images/'.$data->images, ['width'=>'50%']);?>
            <?php }?>
          </div>
          <div class="col-md-2"><label>Document</label></div>
          <div class="col-md-4">
            <?php if(!empty($data->upload_id_proof) && isset($data->upload_id_proof)){?>
              <?=$this->Html->image('id_proof/'.$data->upload_id_proof, ['width'=>'50%']);?>
            <?php }?>
          </div>
        </div>
        <div class="row mt-2">
          <div class="col-md-2"><label>UUID</label></div>
          <div class="col-md-2">: <?=$data->uuid?></div>
          <div class="col-md-2"><label>Data Type</label></div>
          <div class="col-md-2">: <?=$data->category->name?></div>
          <div class="col-md-2"><label>Name</label></div>
          <div class="col-md-2">: <?=$data->salutation?> <?=$data->name?> <?=$data->last_name?></div>
        </div>
        <div class="row mt-2">
          <div class="col-md-2"><label>Mobile No.</label></div>
          <div class="col-md-2">: <?=$data->mobile_no?></div>
          <div class="col-md-2"><label>Whatsapp No.</label></div>
          <div class="col-md-2">: <?=$data->whatsapp_no?></div>
          <div class="col-md-2"><label>Father Name</label></div>
          <div class="col-md-2">: <?=$data->father_name?></div>
        </div>
        <div class="row mt-2">
          <div class="col-md-2"><label>Mother Name</label></div>
          <div class="col-md-2">: <?=$data->mother_name?></div>
          <div class="col-md-2"><label>Gender</label></div>
          <div class="col-md-2">: <?=$data->gender?></div>
          <div class="col-md-2"><label>Age</label></div>
          <div class="col-md-2">: <?=$data->age?></div>
        </div>
        <div class="row mt-2">
          <div class="col-md-2"><label>Date Of Birth</label></div>
          <div class="col-md-2">: <?php if(!empty($data->date_of_birth) && isset($data->date_of_birth)){?><?=date('d-m-Y',strtotime($data->date_of_birth))?><?php }?></div>
          <div class="col-md-2"><label>Anniversary Date</label></div>
          <div class="col-md-2">: <?=$data->anniversary_date?></div>
          <div class="col-md-2"><label>Email ID</label></div>
          <div class="col-md-2">: <?=$data->emailid?></div>
        </div>
        <div class="row mt-2">
          <div class="col-md-2"><label>ID Proof Type</label></div>
          <div class="col-md-2">: <?=$data->id_proof_type?></div>
          <div class="col-md-2"><label>ID Proof Number</label></div>
          <div class="col-md-2">: <?=$data->id_proof_number?></div>
          <div class="col-md-2"><label>Marital Status</label></div>
          <div class="col-md-2">: <?=$data->marital_status?></div>
        </div>
        <div class="row mt-2">
          <div class="col-md-2"><label>State</label></div>
          <div class="col-md-2">: <?=$data->state?></div>
          <div class="col-md-2"><label>District</label></div>
          <div class="col-md-2">: <?=$data->district?></div>
          <div class="col-md-2"><label>City/Town</label></div>
          <div class="col-md-2">: <?=$data->city?></div>
        </div>
        <div class="row mt-2">
          <div class="col-md-2"><label>Address</label></div>
          <div class="col-md-2">: <?=$data->address?></div>
          <div class="col-md-2"><label>Pin Code</label></div>
          <div class="col-md-2">: <?=$data->pincode?></div>
          <div class="col-md-2"><label>Religion</label></div>
          <div class="col-md-2">: <?=$data->religion?></div>
        </div>
        <div class="row mt-2">
          <div class="col-md-2"><label>Occupation</label></div>
          <div class="col-md-2">: <?=$data->occupation?></div>
          <div class="col-md-2"><label>Education</label></div>
          <div class="col-md-2">: <?=$data->education?></div>
          <div class="col-md-2"><label>NEET Roll Number</label></div>
          <div class="col-md-2">: <?=$data->neet_roll_number?></div>
        </div>
        <div class="row mt-2">
          <div class="col-md-2"><label>NEET Score Marks</label></div>
          <div class="col-md-2">: <?=$data->neet_score_markes?></div>
          <div class="col-md-2"><label>Treatment Department</label></div>
          <div class="col-md-2">: <?=(!empty($data->treatment->name) && isset($data->treatment->name))?$data->treatment->name:'';?></div>
          <div class="col-md-2"><label>Recall Date</label></div>
          <div class="col-md-2">: <?=$data->recall_date?></div>
        </div>
        <div class="row mt-2">
          <div class="col-md-2"><label>Remarks</label></div>
          <div class="col-md-4">: <?=$data->remark?></div>
          <div class="col-md-2"><label>Diagnosis</label></div>
          <div class="col-md-4">: 
            <?php if(!empty($data->diagnosis) && isset($data->diagnosis)){
              $explode_diagnosis = explode("~", $data->diagnosis);
              foreach ($explode_diagnosis as $key => $value) {
                echo $value." ,";
              }
            }?>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" onclick="modal_hide()">Close</button>
      </div>
    </div>
  </div>
</div>