<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\Auth\DefaultPasswordHasher;

/**
 * Users Controller
 *
 * @property \App\Model\Table\UsersTable $Users
 *
 * @method \App\Model\Entity\User[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class UsersController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null
     */
    public function index()
    {
        $users = $this->paginate($this->Users);

        $this->set(compact('users'));
    }

    /**
     * View method
     *
     * @param string|null $id User id.
     * @return \Cake\Http\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $user = $this->Users->get($id, [
            'contain' => [],
        ]);

        $this->set('user', $user);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $user = $this->Users->newEntity();
        if ($this->request->is('post')) {
            $data = $this->request->getData();
            //pr($data);die;
            $pass = (new DefaultPasswordHasher)->hash($data['password']);
            $data['password'] = $pass;
            $user = $this->Users->patchEntity($user, $data);
            if ($this->Users->save($user)) {
                $this->Flash->success(__('The user has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The user could not be saved. Please, try again.'));
        }
        $this->set(compact('user'));
    }

    /**
     * Edit method
     *
     * @param string|null $id User id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $string_explode = explode($_COOKIE['csrfToken'], $id);
        if(!empty($string_explode[0]) && isset($string_explode[0])){
            $user = $this->Users->get($string_explode[0], [
                'contain' => [],
            ]);
            if ($this->request->is(['patch', 'post', 'put'])) {
                $user = $this->Users->patchEntity($user, $this->request->getData());
                if ($this->Users->save($user)) {
                    $this->Flash->success(__('The user has been saved.'));

                    return $this->redirect(['action' => 'index']);
                }
                $this->Flash->error(__('The user could not be saved. Please, try again.'));
            }
            $this->set(compact('user'));
        }else{
            return $this->redirect($this->Auth->logout());
        }
    }

    /**
     * Delete method
     *
     * @param string|null $id User id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null,$status)
    {
        $this->request->allowMethod(['post', 'delete']);
        $user = $this->Users->get($id);
        $user['status'] = $status;
        if ($this->Users->save($user)) {
            $this->Flash->success(__('The user has been Update.'));
        } else {
            $this->Flash->error(__('The user could not be Update. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }

    public function login()
    {
        $this->viewBuilder()->setLayout('login');
        if ($this->request->is('post')) {
            $user = $this->Auth->identify();
            if ($user) {
                $this->Auth->setUser($user);
                $session = $this->getRequest()->getSession();
                $this->loadModel('Category');
                $category_list = $this->Category->find('all')->where(['status'=>0])->toArray();
                $session->write('menus', $category_list);
                return $this->redirect($this->Auth->redirectUrl());
            } else {
                $this->Flash->error(__('Username or password is incorrect'));
            }
        }
    }

    public function dashborad()
    {
        $this->loadModel('RecallList');
        if ($this->request->getQuery()) {
            $data = $this->request->getQuery();
            if(!empty($data['from_date']) && isset($data['from_date'])){
                $condation['date(RecallList.recall_date) >='] = date('Y-m-d',strtotime($data['from_date']));
            }else{
                $condation['date(RecallList.recall_date) >='] = date('Y-m-d');
            }
            if(!empty($data['to_date']) && isset($data['to_date'])){
                $condation['date(RecallList.recall_date) <='] = date('Y-m-d',strtotime($data['to_date']));
            }else{
                $condation['date(RecallList.recall_date) <='] = date('Y-m-d');
            }
        }else{
            $condation['date(RecallList.recall_date)'] = date('Y-m-d');
        }
        //pr($condation);die;
        $recall_data = $this->RecallList->find('all')->where([$condation,'RecallList.status'=>0])->contain(['Registrations','TreatmentDepartment']);
        $this->set(compact('recall_data'));
    }

    public function logout()
    {
        return $this->redirect($this->Auth->logout());
    }

    public function category()
    {
        $this->loadModel('Category');
        $category = $this->Category->newEntity();
        if ($this->request->is('post')) {
            $category = $this->Category->patchEntity($category, $this->request->getData());
            if ($this->Category->save($category)) {
                $this->Flash->success(__('The Category has been saved.'));
                return $this->redirect(['action' => 'category']);
            }
            $this->Flash->error(__('The Category could not be saved. Please, try again.'));
        }
        $category_list = $this->paginate($this->Category);
        $this->set(compact('category','category_list'));
    }

    public function deleteCategory($id = null,$status)
    {
        $this->loadModel('Category');
        $this->request->allowMethod(['post', 'delete']);
        $user = $this->Category->get($id);
        $user['status'] = $status;
        if ($this->Category->save($user)) {
            $this->Flash->success(__('The Category has been Update.'));
        } else {
            $this->Flash->error(__('The Category could not be Update. Please, try again.'));
        }

        return $this->redirect(['action' => 'category']);
    }

    public function editCategory($id = null)
    {
        $string_explode = explode($_COOKIE['csrfToken'], $id);
        if(!empty($string_explode[0]) && isset($string_explode[0])){
            $this->loadModel('Category');
            $category = $this->Category->get($string_explode[0], [
                'contain' => [],
            ]);
            if ($this->request->is(['patch', 'post', 'put'])) {
                $category = $this->Category->patchEntity($category, $this->request->getData());
                if ($this->Category->save($category)) {
                    $this->Flash->success(__('The Category has been saved.'));

                    return $this->redirect(['action' => 'category']);
                }
                $this->Flash->error(__('The Category could not be saved. Please, try again.'));
            }
            $this->set(compact('category'));
        }else{
            return $this->redirect($this->Auth->logout());
        }
    }

    public function registration()
    {
        $session = $this->getRequest()->getSession();
        $this->loadModel('Registration');
        $this->loadModel('Counter');
        $registration = $this->Registration->newEntity();
        if ($this->request->is('post')) {
            $array = $this->request->getData();
            $data_check = $this->Registration->find('all')->where(['mobile_no'=>$array['mobile_no'],'data_type'=>$array['data_type']])->first();
			if (empty($data_check)) {
				if (isset($array['image']) && !empty($array['image'])) {
					$file_Name = $this->cepture_patient_image($array['image']);
					$array['images'] = $file_Name;
				}elseif (!empty($array['menula_image']['name']) && isset($array['menula_image']['name'])) {
					$file_Name = date("dmyhis")."".$array['menula_image']['name'];
					move_uploaded_file($array['menula_image']['tmp_name'],WWW_ROOT . 'img/images' . DS . $file_Name);
					$array['images'] = $file_Name;
				}else{
					$array['images'] = '';
				}
				if (!empty($array['upload_id_proof']['name']) && isset($array['upload_id_proof']['name'])) {
					$fileName = date("dmyhis")."".$array['upload_id_proof']['name'];
					move_uploaded_file($array['upload_id_proof']['tmp_name'],WWW_ROOT . 'img/id_proof' . DS . $fileName);
					$array['upload_id_proof'] = $fileName;
				}else{
					$array['upload_id_proof'] = '';
				}
				if(!empty($array['date_of_birth']) && isset($array['date_of_birth'])){
					$array['date_of_birth'] = date('Y-m-d',strtotime($array['date_of_birth']));
				}
                if(!empty($array['recall_date']) && isset($array['recall_date'])){
                    $array['recall_date'] = date('Y-m-d',strtotime($array['recall_date']));
                }
				$array['user_id'] = $session->read('Auth.User.id');
                if (isset($array['diagnosis_name']) && !empty($array['diagnosis_name'])) {
                    $diagnosis_list = implode("~", $array['diagnosis_name']);
                    $array['diagnosis'] = $diagnosis_list;
                }
                
				$registration = $this->Registration->patchEntity($registration, $array);
				//pr($registration);die;
				if ($this->Registration->save($registration)) {
					$uuid_data = $this->Counter->find('all')->where(['counter'=>'uuid'])->toArray();
					$uuid_count = $uuid_data[0]->suffex.''.($uuid_data[0]->count+1);
					$update = $this->Registration->get($registration->id);
					$update['uuid'] = $uuid_count;
					$this->Registration->save($update);
					$update_count = $this->Counter->get($uuid_data[0]->id);
					$update_count['count'] = $uuid_data[0]->count+1;
					$this->Counter->save($update_count);
					if(!empty($array['recall_date']) && isset($array['recall_date'])){
						$this->recall_entery($registration->id);
					}
					$this->Flash->success(__('The Registration has been saved.'));
					return $this->redirect(['action' => 'registration']);
				}
				$this->Flash->error(__('The Registration could not be saved. Please, try again.'));
			}else{
                $this->Flash->error(__('The Mobile Number Already Exists'));
            }
        }
        $this->loadModel('Category');
        $category_list = $this->Category->find('list',['keyFiled'=>'id','valueFiled'=>'name'])->where(['status'=>0]);
        $this->loadModel('States');
        $state_list = $this->States->find('list', ['keyField' => 'name','valueField' => 'name']);
        $this->loadModel('TreatmentDepartment');
        $treatment_department = $this->TreatmentDepartment->find('list', ['keyField'=>'id','valueField'=>'name']);
        $uuid_data = $this->Counter->find('all')->where(['counter'=>'uuid'])->toArray();
        $uuid_count = $uuid_data[0]->suffex.''.($uuid_data[0]->count+1);
        $this->loadModel('Diagnosis');
        $diagnosis_list = $this->Diagnosis->find('list', ['keyField'=>'name','valueField'=>'name']);
        $this->set(compact('category_list','state_list','registration','treatment_department','uuid_count','diagnosis_list'));
    }

    // Cepture Patient Image
    public function cepture_patient_image($image)
    {
        $upload_path = WWW_ROOT.'img/images/';
        $image_parts_expl = explode(";base64,", $image);
        $image_type_aux = explode("image/", $image_parts_expl[0]);

        $image_type = $image_type_aux[1];
        $image_base64 = base64_decode($image_parts_expl[1]);
        $fileName = 'IMAGE'.date("dmyhis").'.png';
        $file = $upload_path . $fileName;
        file_put_contents($file, $image_base64);
        return $fileName;
    }

    public function getDistrictList($id='')
    {
        $this->loadModel('District');
        $district_list = $this->District->find('list', ['keyField' => 'name','valueField' => 'name'])->contain(['States'])->where(['States.name'=>$id])->toArray();
        $district_list[''] = 'Select';
        ksort($district_list);
        $this->set(compact('district_list'));
    }

    public function menuData($string)
    {
        $string_explode = explode($_COOKIE['csrfToken'], $string);
        if(!empty($string_explode[0]) && isset($string_explode[0])){
            $this->loadModel('Category');
            $category = $this->Category->get($string_explode[0]);
            $this->loadModel('Registration');
            $condation = [];
            if ($this->request->getQuery()) {
                $data = $this->request->getQuery();
                if(!empty($data['search_uuid']) && isset($data['search_uuid'])){
                    $condation['uuid'] = $data['search_uuid'];
                }
                if(!empty($data['search_name']) && isset($data['search_name'])){
                    $condation['name LIKE '] = '%'.$data['search_name'].'%';
                }
                if(!empty($data['search_mobile']) && isset($data['search_mobile'])){
                    $condation['mobile_no'] = $data['search_mobile'];
                }
            }
            $this->paginate = [
                'contain' => ['Category'],
            ];
            $registration_data = $this->paginate($this->Registration->find('all')->where(['data_type '=>$string_explode[0],'Registration.status'=>0,$condation])->order(['Registration.id'=>'DESC']));
            $this->set(compact('category','registration_data','string'));
        }else{
            return $this->redirect($this->Auth->logout());
        }
    }

    public function sukanyaForm($string='')
    {
        $string_explode = explode($_COOKIE['csrfToken'], $string);
        if(!empty($string_explode[0]) && isset($string_explode[0])){
            $id = $string_explode[0];
            //pr($id);die;
            $session = $this->getRequest()->getSession();
            $this->loadModel('Registration');
            $this->loadModel('AgeGroups');
            $this->loadModel('SukanyaVaccineChart');
            $sukanya_data = $this->SukanyaVaccineChart->find('all')->where(['registration_id' => $id])->toArray();
            $sukanya_vaccine_chart = $this->SukanyaVaccineChart->newEntity();
            if($this->request->is(['post','put','patch'])){
                $array = $this->request->getData();
                //pr($array);die;
                for ($i=0; $i < count($array['due_date']); $i++) { 
                    if (isset($array['table_id'][$i]) && !empty($array['table_id'][$i])) {
                        $vaccine_chart = $this->SukanyaVaccineChart->get($array['table_id'][$i]);
                    }else{
                        $vaccine_chart = $this->SukanyaVaccineChart->newEntity();
                    }
                    
                    $data['registration_id'] = $id;
                    $data['age_group_id'] = $array['age_group_id'][$i];
                    $data['vaccine_id'] = $array['vaccine_id'][$i];
                    $data['batch_no'] = $array['batch_no'][$i];
                    $data['weight'] = $array['weight'][$i];
                    $data['head_circumference'] = $array['head_circumference'][$i];
                    $data['height'] = $array['height'][$i];
                    $data['comment'] = $array['comment'][$i];
                    $due_date = $array['due_date'][$i];
                    $give_date = $array['given_date'][0];

                    if(isset($give_date) && !empty($give_date)){
                        if (isset($array['due_days'][$i]) && !empty($array['due_days'][$i])) {
                            $due_next_date = $array['due_days'][$i];
                            $find_date = strtotime("+".$due_next_date." days", strtotime($give_date));
                        }
                        if($due_date){
                            $due_date = date('Y-m-d',strtotime($array['due_date'][$i]));
                        }else{
                            $due_date  = date("Y-m-d", $find_date);
                        }
                    }
                    $data['due_date'] = $due_date;
                    if (!empty($array['given_date'][$i]) && isset($array['given_date'][$i])) {
                        $data['given_date'] = date('Y-m-d',strtotime($array['given_date'][$i]));
                    }else{
                        $data['given_date'] = '';
                    }
                    $data['user_id'] = $session->read('Auth.User.id');
                    $vaccine_chart = $this->SukanyaVaccineChart->patchEntity($vaccine_chart, $data);
                    //pr($vaccine_chart);die;
                    $this->SukanyaVaccineChart->save($vaccine_chart);
                }
                $this->Flash->success(__('The Vaccine Chart has been saved.'));
                return $this->redirect($this->Auth->redirectUrl());
            }
            if (!empty($sukanya_data) && isset($sukanya_data)) {
                $agegroups = $this->AgeGroups->find('all')->contain(['VaccineName'])->toArray();
                $age_groups= [];
                foreach ($agegroups as $key => $value) {
                    $age_groups[$key]['id'] = $value->id;
                    $age_groups[$key]['name'] = $value->name;
                    $age_groups[$key]['due_days'] = $value->due_days;
                    foreach ($value->vaccine_name as $keys => $row) {
                        $vaccine_data = $this->SukanyaVaccineChart->find('all')->where(['age_group_id' => $value->id,'vaccine_id' => $row->id,'registration_id'=>$id])->toArray();
                        $age_groups[$key]['vaccine_name'][$keys]['due_date'] = $vaccine_data[0]->due_date;
                        $age_groups[$key]['vaccine_name'][$keys]['given_date'] = $vaccine_data[0]->given_date;
                        $age_groups[$key]['vaccine_name'][$keys]['batch_no'] = $vaccine_data[0]->batch_no;
                        $age_groups[$key]['vaccine_name'][$keys]['weight'] = $vaccine_data[0]->weight;
                        $age_groups[$key]['vaccine_name'][$keys]['head_circumference'] = $vaccine_data[0]->head_circumference;
                        $age_groups[$key]['vaccine_name'][$keys]['height'] = $vaccine_data[0]->height;
                        $age_groups[$key]['vaccine_name'][$keys]['comment'] = $vaccine_data[0]->comment;
                        $age_groups[$key]['vaccine_name'][$keys]['table_id'] = $vaccine_data[0]->id;
                        $age_groups[$key]['vaccine_name'][$keys]['id'] = $vaccine_data[0]->vaccine_id;
                        $age_groups[$key]['vaccine_name'][$keys]['age_group_id'] = $vaccine_data[0]->age_group_id;
                        $age_groups[$key]['vaccine_name'][$keys]['vaccine_name'] = $row->vaccine_name;
                    }
                }
            }else{
                $age_groups = $this->AgeGroups->find('all')->contain(['VaccineName'])->toArray();
            }
            $registration_data = $this->Registration->get($id);
            
            $this->set(compact('sukanya_vaccine_chart','age_groups','registration_data'));
        }else{
            return $this->redirect($this->Auth->logout());
        }
    }

    public function treatmentDepartment()
    {
        $this->loadModel('TreatmentDepartment');
        $treatment_department = $this->TreatmentDepartment->newEntity();
        if($this->request->is('post')){
            $treatment_department = $this->TreatmentDepartment->patchEntity($treatment_department, $this->request->getData());
            if ($this->TreatmentDepartment->save($treatment_department)) {
                $this->Flash->success(__('The Treatment Department has been saved.'));
                return $this->redirect(['action' => 'treatment_department']);
            }
            $this->Flash->error(__('The Treatment Department could not be saved. Please, try again.'));
        }
        $treatment_list = $this->paginate($this->TreatmentDepartment);
        $this->set(compact('treatment_department','treatment_list'));
    }

    public function editTreatmentDepartment($id=null)
    {
        $string_explode = explode($_COOKIE['csrfToken'], $id);
        if(!empty($string_explode[0]) && isset($string_explode[0])){
            $this->loadModel('TreatmentDepartment');
            $treatment_department = $this->TreatmentDepartment->get($string_explode[0], [
                'contain' => [],
            ]);
            if ($this->request->is(['patch', 'post', 'put'])) {
                $treatment_department = $this->TreatmentDepartment->patchEntity($treatment_department, $this->request->getData());
                if ($this->TreatmentDepartment->save($treatment_department)) {
                    $this->Flash->success(__('The Treatment Department has been saved.'));

                    return $this->redirect(['action' => 'treatment_department']);
                }
                $this->Flash->error(__('The Treatment Department could not be saved. Please, try again.'));
            }
            $this->set(compact('treatment_department'));
        }else{
            return $this->redirect($this->Auth->logout());
        }
    }

    public function deleteTreatmentDepartment($id = null,$status)
    {
        $this->loadModel('TreatmentDepartment');
        $this->request->allowMethod(['post', 'delete']);
        $user = $this->TreatmentDepartment->get($id);
        $user['status'] = $status;
        if ($this->TreatmentDepartment->save($user)) {
            $this->Flash->success(__('The Treatment Department has been Deleted.'));
        } else {
            $this->Flash->error(__('The Treatment Department could not be Deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'treatment_department']);
    }

    public function editRegistration($id=null)
    {
        $string_explode = explode($_COOKIE['csrfToken'], $id);
        if(!empty($string_explode[0]) && isset($string_explode[0])){
            $this->loadModel('Registration');
            $registration = $this->Registration->get($string_explode[0], [
                'contain' => [],
            ]);
            //pr($registration);die;
            if ($this->request->is(['patch', 'post', 'put'])) {
                $array = $this->request->getData();
                //pr($array);die;
                if (isset($array['image']) && !empty($array['image'])) {
                    $file_Name = $this->cepture_patient_image($array['image']);
                    $array['images'] = $file_Name;
                }elseif (!empty($array['menula_image']['name']) && isset($array['menula_image']['name'])) {
                    $file_Name = date("dmyhis")."".$array['menula_image']['name'];
                    move_uploaded_file($array['menula_image']['tmp_name'],WWW_ROOT . 'img/images' . DS . $file_Name);
                    $array['images'] = $file_Name;
                }
                if (!empty($array['uploadidproof']['name']) && isset($array['uploadidproof']['name'])) {
                    $fileName = date("dmyhis")."".$array['uploadidproof']['name'];
                    move_uploaded_file($array['uploadidproof']['tmp_name'],WWW_ROOT . 'img/id_proof' . DS . $fileName);
                    $array['upload_id_proof'] = $fileName;
                }
                if(!empty($array['recall_date']) && isset($array['recall_date'])){
                    $array['recall_date'] = date('Y-m-d',strtotime($array['recall_date']));
                }
                if(!empty($array['date_of_birth']) && isset($array['date_of_birth'])){
                    $array['date_of_birth'] = date('Y-m-d',strtotime($array['date_of_birth']));
                }
                if (isset($array['diagnosis_name']) && !empty($array['diagnosis_name'])) {
                    $diagnosis_list = implode("~", $array['diagnosis_name']);
                    $array['diagnosis'] = $diagnosis_list;
                }
                $registration = $this->Registration->patchEntity($registration, $array);
                if ($this->Registration->save($registration)) {
                    $this->Flash->success(__('The Registration has been saved.'));

                    return $this->redirect(['action' => 'menu_data',$registration->data_type.$_COOKIE['csrfToken']]);
                }
                $this->Flash->error(__('The Registration could not be Update. Please, try again.'));
            }
            $this->loadModel('Category');
            $category_list = $this->Category->find('list',['keyFiled'=>'id','valueFiled'=>'name'])->where(['status'=>0]);
            $this->loadModel('States');
            $state_list = $this->States->find('list', ['keyField' => 'name','valueField' => 'name']);
            $this->loadModel('TreatmentDepartment');
            $treatment_department = $this->TreatmentDepartment->find('list', ['keyField'=>'id','valueField'=>'name']);
            $this->loadModel('Diagnosis');
            $diagnosis_list = $this->Diagnosis->find('list', ['keyField'=>'name','valueField'=>'name']);
            $this->set(compact('registration','category_list','state_list','treatment_department','diagnosis_list'));
        }else{
            return $this->redirect($this->Auth->logout());
        }
    }

    public function getViewDocument()
    {
        $id = $this->request->getData('id');
        $this->loadModel('Registration');
        $data = $this->Registration->get($id);
        $this->set(compact('data'));
    }

    public function deleteRegistration($string)
    {
        $string_explode = explode($_COOKIE['csrfToken'], $string);
        if(!empty($string_explode[0]) && isset($string_explode[0])){
            $this->loadModel('Registration');
            $data = $this->Registration->get($string_explode[0]);
            $data['status'] = 1;
            $this->Registration->save($data);
            $this->Flash->success(__('The Registration has been Deleted.'));
            return $this->redirect(['action' => 'menu_data',$data->data_type.$_COOKIE['csrfToken']]);
        }else{
            return $this->redirect($this->Auth->logout());
        }
    }

    public function viewRegistrationData()
    {
        $id = $this->request->getData('id');
        $this->loadModel('Registration');
        $data = $this->Registration->get($id, [
            'contain'=> ['Category','Treatment']
        ]);
        $this->set(compact('data'));
    }

    public function recall_entery($id)
    {
        $this->loadModel('Registration');
        $re_data = $this->Registration->get($id);
        $this->loadModel('RecallList');
        $recall = $this->RecallList->newEntity();
        $recallData['registration_id'] = $id;
        $recallData['recall_date'] = date('Y-m-d',strtotime($re_data->recall_date));
        $recallData['remarks'] = $re_data->remark;
        $recallData['treatment'] = $re_data->treatment_department;
        $recall = $this->RecallList->patchEntity($recall, $recallData);
        $this->RecallList->save($recall);
        //pr($recall);die;
    }

    public function confirmRecall()
    {
        $id = $this->request->getData('id');
        $this->loadModel('RecallList');
        $data = $this->RecallList->get($id);
        $data['status'] = 1;
        $this->RecallList->save($data);exit;
    }

    public function actionRecallAdd()
    {
        $id = $this->request->getData('id');
        $this->loadModel('RecallList');
        $data = $this->RecallList->find('all')->where(['registration_id'=>$id])->contain(['Registrations'])->toArray();
        $this->loadModel('TreatmentDepartment');
        $treatment_department = $this->TreatmentDepartment->find('list', ['keyField'=>'id','valueField'=>'name']);
        //pr($data);die;
        $this->set(compact('data','treatment_department','id'));
    }

    public function recalldataSave()
    {
        if ($this->request->getQuery()) {
            $array = $this->request->getQuery();
            $this->loadModel('RecallList');
            $this->loadModel('Registration');
            $regi_data = $this->Registration->get($array['registrationid']);
            $recall_data = $this->RecallList->newEntity();
            $data['registration_id'] = $array['registrationid'];
            $data['recall_date'] = date('Y-m-d',strtotime($array['recall_date']));
            $data['remarks'] = $array['remark'];
            $data['treatment'] = $array['treatment_department'];
            $recall_data = $this->RecallList->patchEntity($recall_data,$data);
            $this->RecallList->save($recall_data);
            $this->Flash->success(__('The Recall has been Saved.'));
            return $this->redirect(['action' => 'menu_data',$regi_data->data_type.$_COOKIE['csrfToken']]);
        }
    }

    public function reporting()
    {
        $this->loadModel('Category');
        $category = $this->Category->find('list', ['keyField'=>'id','valueField'=>'name']);
        $this->loadModel('Diagnosis');
        $diagnosis_list = $this->Diagnosis->find('list', ['keyField'=>'name','valueField'=>'name']);
        $this->set(compact('category','diagnosis_list'));
    }

    public function categoryWiseReport()
    {
        $string = $this->request->getData('string');
        $explode_string = explode("@", $string);
        //pr($explode_string);die;
        $condation['Registration.status'] = 0;
        $from_date = '';
        if (!empty($explode_string[0]) && isset($explode_string[0])) {
            $condation['date(Registration.date_add) >='] = date('Y-m-d',strtotime($explode_string[0]));
            $from_date = date('d-m-Y',strtotime($explode_string[0]));
        }
        $to_date = '';
        if (!empty($explode_string[1]) && isset($explode_string[1])) {
            $condation['date(Registration.date_add) <='] = date('Y-m-d',strtotime($explode_string[1]));
            $to_date = date('d-m-Y',strtotime($explode_string[1]));
        }
        if (!empty($explode_string[2]) && isset($explode_string[2])) {
            $data_type = explode(",", $explode_string[2]);
            $condation['data_type IN '] = $data_type;
        }
        if (!empty($explode_string[3]) && isset($explode_string[3])) {
            $condation['diagnosis LIKE '] = '%'.$explode_string[3].'%';
        }
        //pr($condation);die;
        $this->loadModel('Registration');
        $data = $this->Registration->find('all')->where([$condation])->contain(['Category','Treatment']);
        $this->set(compact('data','from_date','to_date'));
    }
    public function dateOfBirthAlert()
    {
        $this->loadModel('Registration');
        if ($this->request->getQuery()) {
            $data = $this->request->getQuery();
            if(!empty($data['month']) && isset($data['month'])){
                //pr(date('m-d',strtotime($data['month'])));die;
                $condation['Registration.date_of_birth LIKE '] = '%-'.date('m-d',strtotime($data['month']));
                $month = $data['month'];
            }else{
                $condation['Registration.date_of_birth LIKE '] = '%-'.date('m-d');
                $month = '';
            }
        }else{
            $condation['Registration.date_of_birth LIKE '] = '%-'.date('m-d');
            $month = date('d-m-Y');
        }
        //pr($condation);die;
        $birth_data = $this->Registration->find('all')->where([$condation,'Registration.status'=>0])->contain(['Category']);
        $this->set(compact('birth_data','month'));
    }

    public function sendBirthdaySms()
    {
        $this->loadModel('Registration');
        $month = $this->request->getData('month');
        $condation['Registration.date_of_birth LIKE '] = '%-'.date('m-d');
        $birth_data = $this->Registration->find('all')->select(['salutation','mobile_no','name','last_name'])->where([$condation,'Registration.status'=>0])->toArray();
        //pr($birth_data);die;
        foreach ($birth_data as $key => $value) {
            if(!empty($value->mobile_no) && isset($value->mobile_no)){
                $student_name = $value->salutation.' '.$value->name.' '.$value->last_name;
                $mobile_no = $value->mobile_no;
                $messss =  'Dear '.$student_name.' Happy Birthday. On this special day, we wish you good health, happiness, and prosperity for years.Hazaribag Dental College - SARVAMANGLAM';
                $request ="";
                $param['authentic-key']= '35366f6d36303318';
                $param['senderid'] = 'HCDSHI';
                $param['route'] = '2';
                $param['number'] = $mobile_no;
                $param['message'] = urlencode($messss);
                $param['templateid'] = '1207169953235029958';
                                        
                foreach ($param as $key=>$val) {
                    $request.= $key."=".$val;
                    $request.= "&";
                }
                                
                $request = substr($request, 0, strlen($request)-1);
                $url =  "http://weberleads.in/http-tokenkeyapi.php?".$request;
                //print_r($url);die;
                $c = curl_init();
                curl_setopt($c, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($c, CURLOPT_URL, $url);
                $contents = curl_exec($c);
                //echo "<pre>";print_r($contents);die;
                curl_close($c);
            }
        }
        echo "0";exit;

    }
    public function sendBirthdayBulkSmsGateway()
    {
        $this->loadModel('Registration');
        $month = $this->request->getData('month');
        $condation['Registration.date_of_birth LIKE '] = '%-'.date('m-d');
        $birth_data = $this->Registration->find('all')->select(['salutation','mobile_no','name','last_name'])->where([$condation,'Registration.status'=>0])->toArray();
        //pr($birth_data);die;
        foreach ($birth_data as $key => $value) {
            if(!empty($value->mobile_no) && isset($value->mobile_no)){
                $student_name = $value->salutation.' '.$value->name.' '.$value->last_name;
                $mobile_no = $value->mobile_no;
                $messss =  'Dear '.$student_name.' Happy Birthday. On this special day, we wish you good health, happiness, and prosperity for years.Hazaribag Dental College - SARVAMANGLAM';
                $request ="";
                $param['user']= urlencode('hcdsh123');
                $param['password'] = urlencode('Hcdsh@123');
                $param['mobile'] = urlencode($mobile_no);
                $param['message'] = urlencode($messss);
                $param['sender'] = urlencode('HCDSHI');
                $param['type'] = urlencode('3');
                $param['template_id'] = urlencode('1207169953235029958');
                                        
                foreach ($param as $key=>$val) {
                    $request.= $key."=".$val;
                    $request.= "&";
                }
                                
                $request = substr($request, 0, strlen($request)-1);
                $url =  "http://api.bulksmsgateway.in/sendmessage.php?".$request;
                //print_r($url);die;
                $c = curl_init();
                curl_setopt($c, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($c, CURLOPT_URL, $url);
                $contents = curl_exec($c);
                //echo "<pre>";print_r($contents);die;
                curl_close($c);
            }
        }
        echo "0";exit;

    }

    public function anniversaryDateAlert()
    {
        $this->loadModel('Registration');
        if ($this->request->getQuery()) {
            $data = $this->request->getQuery();
            if(!empty($data['month']) && isset($data['month'])){
                $condation['Registration.anniversary_date LIKE'] = '%-'.$data['month'].'-%';
            }else{
                $condation['Registration.anniversary_date LIKE '] = date('d-m').'-%';
            }
        }else{
            $condation['Registration.anniversary_date LIKE '] = date('d-m').'-%';
        }
        //pr($condation);die;
        $anniversary_data = $this->Registration->find('all')->where([$condation,'Registration.status'=>0])->contain(['Category']);
        $this->set(compact('anniversary_data'));
    }
    public function sendSms()
    {
        $this->loadModel('Registration');
        if ($this->request->getQuery()) {
            $array = $this->request->getQuery();
            $condation = [];
            if (!empty($array['category']) && isset($array['category'])) {
                $condation['data_type'] = $array['category'];
            }
            if (!empty($array['tr_department']) && isset($array['tr_department'])) {
                $condation['treatment_department'] = $array['tr_department'];
            }
            $registration_data = $this->Registration->find('all')->select(['mobile'=>'mobile_no'])->where(['mobile_no !='=>'','status'=>0,$condation])->toArray();
            //pr($array);die;
            foreach ($registration_data as $key => $value) {
                if (!empty($value->mobile) && isset($value->mobile)) {
                    if($array['sms_gateway']==1){
                        $request ="";
                        $param['authentic-key']= '35366f6d36303318';
                        $param['senderid'] = 'HCDSHI';
                        $param['route'] = '2';
                        $param['number'] = $value->mobile;
                        $param['message'] = urlencode($array['template_data']);
                        $param['templateid'] = $array['templateid'];
                                                
                        foreach ($param as $key=>$val) {
                            $request.= $key."=".$val;
                            $request.= "&";
                        }
                                        
                        $request = substr($request, 0, strlen($request)-1);
                        $url =  "http://weberleads.in/http-tokenkeyapi.php?".$request;
                        $c = curl_init();
                        curl_setopt($c, CURLOPT_RETURNTRANSFER, 1);
                        curl_setopt($c, CURLOPT_URL, $url);
                        $contents = curl_exec($c);
                        //echo "<pre>";print_r($contents);die;
                        curl_close($c);

                    }elseif($array['sms_gateway']==2){
                        $request ="";
                        $param['user']= urlencode('hcdsh123');
                        $param['password'] = urlencode('Hcdsh@123');
                        $param['mobile'] = urlencode($value->mobile);
                        $param['message'] = urlencode($array['template_data']);
                        $param['sender'] = urlencode('HCDSHI');
                        $param['type'] = urlencode('3');
                        $param['template_id'] = urlencode($array['templateid']);
                                                
                        foreach ($param as $key=>$val) {
                            $request.= $key."=".$val;
                            $request.= "&";
                        }
                                        
                        $request = substr($request, 0, strlen($request)-1);
                        $url =  "http://api.bulksmsgateway.in/sendmessage.php?".$request;
                        $c = curl_init();
                        curl_setopt($c, CURLOPT_RETURNTRANSFER, 1);
                        curl_setopt($c, CURLOPT_URL, $url);
                        $contents = curl_exec($c);
                        //echo "<pre>";print_r($contents);die;
                        curl_close($c);
                    }
                }
            }
            $this->Flash->success(__('Sms Send Successfully'));
            return $this->redirect(['action' => 'send-sms']);
        }
        $this->loadModel('Category');
        $category = $this->Category->find('list', ['keyField'=>'id','valueField'=>'name'])->order(['name'=>'ASC']);
        $this->loadModel('TreatmentDepartment');
        $treatment_department = $this->TreatmentDepartment->find('list', ['keyField'=>'id','valueField'=>'name'])->order(['name'=>'ASC']);
        $this->loadModel('TemplateLists');
        $tamplate_list = $this->TemplateLists->find('list', ['keyField'=>'id','valueField'=>'template_name'])->order(['template_name'=>'ASC']);
        $this->set(compact('category','treatment_department','tamplate_list'));
    }
    public function getTemplateData()
    {
        $id = $this->request->getData('id');
        $this->loadModel('TemplateLists');
        $template_data = $this->TemplateLists->get($id);
        echo $template_data->templatedata.'@'.$template_data->tamplateid;exit;
    }
    public function templateList()
    {
        $this->loadModel('TemplateLists');
        $template_lists = $this->TemplateLists->newEntity();
        if ($this->request->is('post')) {
            $array = $this->request->getData();
            $template_lists = $this->TemplateLists->patchEntity($template_lists,$array);
            if($this->TemplateLists->save($template_lists)){
                $this->Flash->success(__('The Template has been saved.'));
                return $this->redirect(['action' => 'template-list']);
            }
            $this->Flash->error(__('The Template could not be saved. Please, try again.'));
        }
        $template_list = $this->paginate($this->TemplateLists);
        $this->set(compact('template_lists','template_list'));
    }
    public function editTemplate($id)
    {
        $this->loadModel('TemplateLists');
        $string_explode = explode($_COOKIE['csrfToken'], $id);
        if(!empty($string_explode[0]) && isset($string_explode[0])){
            $this->loadModel('TemplateLists');
            $template_lists = $this->TemplateLists->get($string_explode[0]);
            if ($this->request->is(['patch', 'post', 'put'])) {
                $array = $this->request->getData();
                $template_lists = $this->TemplateLists->patchEntity($template_lists,$array);
                if($this->TemplateLists->save($template_lists)){
                    $this->Flash->success(__('The Template has been saved.'));
                    return $this->redirect(['action' => 'template-list']);
                }
                $this->Flash->error(__('The Template could not be saved. Please, try again.'));
            }
            $this->set(compact('template_lists'));
        }else{
            return $this->redirect($this->Auth->logout());
        }
    }

    public function deleteTemplate($string)
    {
        $string_explode = explode($_COOKIE['csrfToken'], $string);
        if(!empty($string_explode[0]) && isset($string_explode[0])){
            $this->loadModel('TemplateLists');
            $data = $this->TemplateLists->get($string_explode[0]);
            $this->TemplateLists->delete($data);
            $this->Flash->success(__('The Template has been Deleted.'));
            return $this->redirect(['action' => 'template-list']);
        }else{
            return $this->redirect($this->Auth->logout());
        }
    }

    public function diagnosisLists()
    {
        $this->loadModel('Diagnosis');
        $diagnosis = $this->Diagnosis->newEntity();
        if ($this->request->is('post')) {
            $diagnosis = $this->Diagnosis->patchEntity($diagnosis, $this->request->getData());
            if ($this->Diagnosis->save($diagnosis)) {
                $this->Flash->success(__('The Diagnosis has been saved.'));
                return $this->redirect(['action' => 'diagnosis-lists']);
            }
            $this->Flash->error(__('The Diagnosis could not be saved. Please, try again.'));
        }
        $diagnosis_list = $this->paginate($this->Diagnosis);
        $this->set(compact('diagnosis','diagnosis_list'));
    }
    public function editDiagnosis($id = null)
    {
        $string_explode = explode($_COOKIE['csrfToken'], $id);
        if(!empty($string_explode[0]) && isset($string_explode[0])){
            $this->loadModel('Diagnosis');
            $diagnosis = $this->Diagnosis->get($string_explode[0]);
            if ($this->request->is(['patch', 'post', 'put'])) {
                $diagnosis = $this->Diagnosis->patchEntity($diagnosis, $this->request->getData());
                if ($this->Diagnosis->save($diagnosis)) {
                    $this->Flash->success(__('The Diagnosis has been saved.'));

                    return $this->redirect(['action' => 'diagnosis-lists']);
                }
                $this->Flash->error(__('The Diagnosis could not be saved. Please, try again.'));
            }
            $this->set(compact('diagnosis'));
        }else{
            return $this->redirect($this->Auth->logout());
        }
    }
}
