<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * SukanyaVaccineChart Entity
 *
 * @property int $id
 * @property int $registration_id
 * @property int $age_group_id
 * @property int $vaccine_id
 * @property \Cake\I18n\FrozenDate $due_date
 * @property \Cake\I18n\FrozenDate|null $given_date
 * @property string|null $batch_no
 * @property string|null $weight
 * @property string|null $head_circumference
 * @property string|null $height
 * @property string|null $comment
 * @property \Cake\I18n\FrozenTime $add_date
 * @property int $user_id
 *
 * @property \App\Model\Entity\Registration $registration
 * @property \App\Model\Entity\AgeGroup $age_group
 * @property \App\Model\Entity\Vaccine $vaccine
 * @property \App\Model\Entity\User $user
 */
class SukanyaVaccineChart extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        'registration_id' => true,
        'age_group_id' => true,
        'vaccine_id' => true,
        'due_date' => true,
        'given_date' => true,
        'batch_no' => true,
        'weight' => true,
        'head_circumference' => true,
        'height' => true,
        'comment' => true,
        'add_date' => true,
        'user_id' => true,
        'registration' => true,
        'age_group' => true,
        'vaccine' => true,
        'user' => true,
    ];
}
