<div class="card text-center">
  	<div class="card-header bg-success">Send SMS</div>
  	<div class="card-body" align="left">
  		<form action="<?= $this->Url->build(['controller'=>'users','action'=>'send-sms']) ?>">
	   		<div class="row">
	   			<div class="col-md-3">
	   				<strong>Category</strong>
	   				<?=$this->Form->control('category', ['label'=>false,'options'=>$category,'empty'=>'Category','class'=>'form-control'])?>
	   			</div>
	   			<div class="col-md-3">
	   				<strong>Treatment Department</strong>
	   				<?=$this->Form->control('tr_department', ['label'=>false,'options'=>$treatment_department,'empty'=>'Treatment  Department','class'=>'form-control'])?>
	   			</div>
	   			<div class="col-md-3">
	   				<strong>Template Name</strong>
	   				<?=$this->Form->control('template_name', ['options'=>$tamplate_list,'empty'=>'Template Name','label'=>false,'class'=>'form-control','onchange'=>'get_template_data(this.value)','required'=>true])?>
	   			</div>
	   			<div class="col-md-3">
	   				<strong>SMS Gateway Use</strong>
	   				<?=$this->Form->control('sms_gateway', ['options'=>[''=>'SMS Gateway','1'=>'Perfect SMS Gateway','2'=>'Bulk SMS Gateway'],'required'=>true,'label'=>false,'class'=>'form-control'])?>
	   			</div>
	   		</div>
	   		<div class="row mt-2">
	   			<div class="col-md-12">
	   				<strong>Template Data</strong>
	   				<?=$this->Form->textarea('template_data', ['label'=>false,'style'=>'width:100%;','id'=>'templatedata','class'=>'form-control','required'=>true])?>
	   				<?=$this->Form->control('templateid', ['label'=>false,'type'=>'hidden'])?>
	   				Total Characters : <span id="total_word"></span>
	   			</div>
	   		</div>
	   		<div class="row mt-2">
	   			<div class="col-md-12" align="center">
	   				<?=$this->Form->button('SEND SMS', ['class'=>'btn btn-primary'])?>
	   			</div>
	   		</div>
	   	</form>
  	</div>
</div>
<?= $this->Html->script('libs/jquery/dist/jquery.min.js') ?>
<script type="text/javascript">
	$("#templatedata").on('keyup', function() {
		var words = $(this).val().length;
      	$('#total_word').text(words);
	});

	function get_template_data(id)
	{
		if(id!=''){
			var csrfToken = <?= json_encode($this->request->getParam('_csrfToken')) ?>;
		    $.ajax({
		      type:'POST',
		      url:'<?php echo $this->Url->build(['controller'=>'users','action'=>'get_template_data']); ?>',
		      data:{id:id},
		      headers: { 'X-CSRF-Token': csrfToken },
		      success:function(data){
		      	var string = data.split("@");
		      	var string_length = string[0].length;
		        $("#templatedata").val(string[0]);
		        $('#total_word').text(string_length);
		        $("#templateid").val(string[1]);
		      }
		    });
		}else{
			$("#templatedata").val('');
			$('#total_word').text(0);
			$("#templateid").val('');
		}
	}
</script>