<?php $session = $this->getRequest()->getSession();?>
<?= $this->Form->create($template_lists) ?>
	<div class="row">
	    <div class="col-lg-12 d-flex align-items-strech">
	      	<div class="card w-100">
	        	<div class="card-body">
	          		<div class="d-sm-flex d-block align-items-center justify-content-between mb-9">
	            		<div class="mb-3 mb-sm-0" align="center">
	              			<h5 class="card-title fw-semibold">Add Template</h5>
	            		</div>
	          		</div>
	          		<div class="row">
	          			<div class="col-md-6">
	          				<label>Template Name <span class="text-danger">*</span></label>
	          				<?=$this->Form->control('template_name', ['label'=>false,'placeholder'=>'Enter Template Name','class'=>'form-control','required'=>true])?>
	          			</div>
	          			<div class="col-md-6">
	          				<label>Template-ID <span class="text-danger">*</span></label>
	          				<?=$this->Form->control('tamplateid', ['label'=>false,'placeholder'=>'Enter Template-ID','class'=>'form-control','required'=>true])?>
	          			</div>
	          		</div>
	          		<div class="row mt-2">
	          			<div class="col-md-12">
	          				<label>Template Data <span class="text-danger">*</span></label>
	          				<?=$this->Form->textarea('templatedata',['style'=>'width:100%;','id'=>'templatedata'])?>
	          				Total Characters : <span id="total_word"></span>
	          			</div>
	          		</div>
	          		<div class="row mt-2">
	          			<div class="col-md-12" align="center">
	          				<?=$this->Form->button('save', ['class'=>'btn btn-success'])?>
	          			</div>
	          		</div>
	          	</div>
	     	</div>
	  	</div>
	</div>
<?= $this->Form->end() ?>
<div class="row">
    <div class="col-md-12"><hr></div>
</div>
<div class="row">
    <div class="col-md-12" align="center"><strong><h1>List Template</h1></strong></div>
</div>
<div class="row">
    <div class="col-md-12"><hr></div>
</div>
<table class="table table-bordered">
    <thead>
        <tr>
            <th scope="col"><?= $this->Paginator->sort('template_name') ?></th>
            <th scope="col"><?= $this->Paginator->sort('tamplateid') ?></th>
            <th scope="col"><?= $this->Paginator->sort('templatedata') ?></th>
            <th scope="col" class="actions"><?= __('Actions') ?></th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($template_list as $template): ?>
        <tr>
            <td><?= $template->template_name ?></td>
            <td><?= h($template->tamplateid) ?></td>
            <td><?=$template->templatedata?></td>
            <td class="actions">
                <?php if($session->read('Auth.User.user_roal')==1){?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit_template', $template->id.$_COOKIE['csrfToken']],['class'=>'btn btn-success']) ?>
                    <?= $this->Html->link(__('Delete'), ['action' => 'delete_template', $template->id.$_COOKIE['csrfToken']],['class'=>'btn btn-danger']) ?>
                <?php }?>
            </td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>
 <div class="paginator">
    <ul class="pagination">
        <?= $this->Paginator->first('<< ' . __('first')) ?>
        <?= $this->Paginator->prev('< ' . __('previous')) ?>
        <?= $this->Paginator->numbers() ?>
        <?= $this->Paginator->next(__('next') . ' >') ?>
        <?= $this->Paginator->last(__('last') . ' >>') ?>
    </ul>
    <p><?= $this->Paginator->counter(['format' => __('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')]) ?></p>
</div>
<?= $this->Html->script('libs/jquery/dist/jquery.min.js') ?>
<script type="text/javascript">
	$("#templatedata").on('keyup', function() {
		var words = $(this).val().length;
      	$('#total_word').text(words);
	});
</script>